﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Helpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for AddEditHappyHours.xaml
    /// </summary>
    public partial class AddEditHappyHours : Window
    {
        public AddEditHappyHours()
        {
            InitializeComponent();
        }

        private void btnSave_Click(object sender, RoutedEventArgs e)
        {
            if (Validate())
            {
                List<HappyHours> _happyHours = HappyHourPromoBL.GetList(Guid.Empty);
                if (_happyHours != null && _happyHours.Count > 0)
                {
                    _happyHours = _happyHours.Where(a => a.IsEnabled).ToList<HappyHours>();
                }
                //Initialise the object if it is null;
                _happyHours = _happyHours == null ? new List<HappyHours>() : _happyHours;
                HappyHours _HappyHour = new HappyHours();
                _HappyHour.PromoName = txtPromoName.Text.Trim();
                _HappyHour.DisplayStartTime = (ddlStartTime.SelectedItem as ComboBoxItem).Content.ToString();
                _HappyHour.StartTime = GetTime(ddlStartTime);
                _HappyHour.DisplayEndTime = (ddlEndTime.SelectedItem as ComboBoxItem).Content.ToString();
                _HappyHour.EndTime = GetTime(ddlEndTime);
                _HappyHour.IsEnabled = true;
                HappyHourPromoBL.Save(_HappyHour);
                this.Tag = true;
                this.Close();
            }
        }

        private DateTime GetTime(ComboBox cmbbox)
        {
            string selectedTime = (cmbbox.SelectedItem as ComboBoxItem).Content.ToString();
            bool IsMorning = selectedTime.Contains("AM");
            int Hour = IsMorning ? int.Parse(selectedTime.Replace("AM", "")) : int.Parse(selectedTime.Replace("PM", ""));
            Hour = (IsMorning && Hour == 12) ? 0 : (IsMorning ? Hour : (Hour!=12?Hour + 12:12));
            DateTime selctedDateTime = new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.Now.Day, Hour, 0, 0);
            return selctedDateTime;
        }

        private bool Validate()
        {
            DateTime StartTime = GetTime(ddlStartTime);
            DateTime EndTime = GetTime(ddlEndTime);
            if (string.IsNullOrEmpty(txtPromoName.Text))
            {
                MessageBox.Show("Please enter a valid promotion name");
                return false;
            }
            //if promo extends to second day and the end time is not 12 AM 
            if ( StartTime > EndTime && EndTime.Hour != 0)
            {
                MessageBox.Show("Please check the selected time. For promotions extending to day two (after 12 AM) please create an another promo from 12 AM.");
                return false;
            }
            return true;
        }

        private void btnClose_Click(object sender, RoutedEventArgs e)
        {
            this.Tag = false;
            this.Close();
        }
    }
}
